
local assets=
{
	Asset("ANIM", "anim/drop_lightsword.zip"),
    Asset("ANIM", "anim/lightsword.zip"), 
    Asset("ATLAS", "images/inventoryimages/lightsword.xml"),
}

local prefabs = 
{
    "axe", 
}
local function onfinished(inst)
  inst:Remove()
end
local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "lightsword", "lightsword")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 

	end

local function canpickup(inst)
	local stewer = inst.components.stewer
	local container = inst.components.container

	if not stewer or not container then
		--Something has gone very wrong...
		return false
	end

	return container:IsEmpty() 
end
local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end
local function fn()
local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("drop_lightsword")
    inst.AnimState:SetBuild("drop_lightsword")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("weapon")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "lightsword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lightsword.xml"
     
    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
		
	inst:AddComponent("inspectable")
	local light = inst.entity:AddLight()
	light:SetColour(51/255, 255/255, 255/255)
	light:SetIntensity(0.8)
	light:SetRadius(2.2)
	light:SetFalloff(.33)
	inst.Light:Enable(true)
	inst:AddTag("lightsword")
    inst.components.weapon:SetDamage(50)
		inst.components.inventoryitem.onputininventoryfn = function(inst, player)
		--If it's in their inventory
		local owner = inst.components.inventoryitem:GetGrandOwner()
		if player.components.inventory and player.prefab ~= "tobiichiorigami" then 
			inst:DoTaskInTime(0.1, function()
			
			player.components.inventory:DropItem(inst)
			inst.components.talker:Say("我不是AST成员")
			end)
		--If it's in a container		
		elseif player.components.container and owner.prefab ~= "tobiichiorigami" then 
			inst:DoTaskInTime(0.1, function()
			
			player.components.container:DropItem(inst)
			inst.components.talker:Say("我塞不进包里")
			end)
		end
	end
    return inst
end
return Prefab("lightsword", fn, assets)